* Do-fil til kapittel 8
use "https://nedlasting.fagbokforlaget.no/stata/abu89.dta", clear
************************
** Eksempel 1
**********
* Fordelingen for den avhengige variabelen
tabu promot
** Den lineære sannsynlighetsmodellen
regress promot female ed fexp private
predict plin
* Logistisk regresjon
logit promot female ed fexp private
** beregne OR
logit, or
* Bergne maksimaleffekter av ed og fexp i oddsskalaen
display exp(0.102*9)
display exp(0.584*3)
** Predikerte sannsynligheter for female og private
margins, at(female=(0, 1))
margins, at(private=(0, 1))
** predikerte sannsynligheter for ed
margins, at(ed=(0(1)9))
marginsplot, recast(line) recastci(rarea)
** Predikerte sannsynligheter for fexp
** Figur 8.3 med addplot
margins, at(fexp=(0(.2)5))
marginsplot, recast(line) recastci(rarea)
***
marginsplot, noci recast(line) addplot (line plin fexp, sort )
**

*********************************
** Eksempel 2
**********
use "https://nedlasting.fagbokforlaget.no/stata/ESS7NO_Helse2.dta", clear
* Hvordan depresjonsskalaen cesd8 lages er vist i do-filen til kapittel 7
* snu tallkodene på to spørsmål 
gen wrhpp_r = 5 - wrhpp
gen enjlf_r = 5 - enjlf
* missing indikator
egen cesd_miss = rowmiss(fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng)
tabu cesd_miss
* Lage depresjonsskalaen
egen float cesd8 = rowmean(fltdpr flteeff slprl wrhpp_r fltlnl /// 
  enjlf_r fltsd cldgng) if cesd_miss < 3   /* skala 8 items */
*
** Lage dikotom avhengig variabel på basis av cesd8 > 2
recode cesd8 (1.0/2.0=0)(2.1/4=1), gen(dep)
tabu dep
*** Klargjør uavhengige variabler til logistisk reegresjon av dep.
* alder4 og utdniv finnes i filen og kan brukes uendret
recode icpart2 (1=1)(2=0), gen(sambo)
label variable sambo "Samboer,ektefelle,partner, fra icpart2"
clonevar personlig = inprdsc
label variable personlig "Snakke med om personlige ting, fra inprdsc
clonevar mosjon = dosprt
label variable mosjon "Antall ganger mosjon siste uke, fra dosprt"
*
** Beskrive variablene
summ dep alder4 kvinne utdniv sambo personlig mosjon
* logistisk regresjon
logit dep i.alder4 i.kvinne i.utdniv i.sambo personlig mosjon
logit, or
* Har alder en signifikant effekt?
contrast alder4 
* alder4 
* Har utdanningsnivå en signifikant effekt?
contrast utdniv
* Ny modell uten alder
logit dep i.kvinne i.utdniv i.sambo personlig mosjon 
* Ny modell uten personlig
logit dep i.kvinne i.utdniv i.sambo mosjon
di -2*(-400.83 - (-397.34))
di chi2tail(4, 6.98)
*** begge kan utelates.
******************
* Tolkning av endelig modell
*******
logit dep i.kvinne i.utdniv i.sambo mosjon
logit, or
** sannsynligheter for kvinne
margins kvinne
* sannsynligheter for utdanning
margins utdniv
** sannsynligheter for sambo
margins  sambo
*** makismaleffelt for mosjon
di exp(-0.1665*7)
* sannsynligheter for mosjon
margins, at (mosjon=(0, 7))
**************************************
* Tilpasningstester (Goodness of fit)
************
estat gof   /* lfit gjør det samme*/
** Hosmer-Lemeshow test
estat gof, table group(10)
* Finne terskelverdi
mean dep
* Klassifikasjonstesten
estat classification, cut(.09)
* ROC-kurven
lroc
******************* 
*** Residualanalyse
********
** Lage variabel for kovariatmønstre
predict km, number
sort km idno
list km idno kvinne utdniv sambo mosjon in 1/20
** Predikerte sannsynligheter for dep=1
predict pdep, pr
** H-L Delta chi-squared influence statistic
predict dx2, dx2
** 
** Hat statistic
predict hat, hat
* Standardiserte Pearson residualer
predict spr, rstandard
* Pregibons Delta-Beta mål på innflytelse
predict db, dbeta
****************************
* Figurer
******
*** Figur 8.6 Hat statistic (leverage) etter stand. Pearson residualer
scatter hat spr, mlab(km) xline(0)
* Figur 8.7 Delta kjikvadrat - innflytelse
scatter dx2 pdep, mlab(km)yline(4)
* Figur 8.8 dbeta etter kovariatmøntre
scatter db km, mlab(km)
* Figur 8.9  dx2 etter p med sirkerstørrelse etter db
scatter dx2 pdep [w=db], yline(4) mfcolor(white)

********************************
*** Estimering av modellen uten enheter med stor innflytelse
*************
recode km (1 3 9 105 113 = 2)(4 10 11 12 30 55 66 = 1)(else =0), gen(innfl)
*** Estimering uten innfl=2
logit dep i.kvinne i.utdniv i.sambo mosjon if innfl < 2
*** Se innflytelsen av to store kovariatmønstre med menn
recode km(1 113=1)(else=0), gen(km1_113)
*
*** Sjekk for mulig bias (sensitivitettest)
margins kvinne if innfl <= 1
*** Se på de avvkende mønstrene
list km id kvinne utdniv sambo mosjon if innfl == 2
* uten km=113
logit dep i.kvinne i.utdniv i.sambo mosjon if km != 113
**************************
*** Sub-gruppenelyse etter kjønn 
***********
quietly: logit dep i.utdniv sambo mosjon if kvinne == 0
estimates store Menn
quietly: logit dep i.utdniv sambo mosjon if kvinne == 1
estimates store Kvinner
suest Kvinner Menn, eform(Odds Ratio)
** Test for om estimatene er like for menn og kvinner
test [Kvinner_dep = Menn_dep]
*** tester likheter mellom to koeffisienter
test [Kvinner_dep]sambo = [Menn_dep]sambo
test [Kvinner_dep]2.utdniv - [Menn_dep]2.utdniv = 0
*********






